﻿using System.ComponentModel.DataAnnotations;
using System.Xml.Serialization;

// ReSharper disable InconsistentNaming

namespace PlatezhkaDemoApi.Models.Requests
{
    [XmlRoot("commandCall")]
    public class CancelCommand
    {
        /// <summary>
        /// Логин используемый для идентификации системы
        /// </summary>
        [Required]
        public string login { get; set; }
        /// <summary>
        /// Пароль используемый для идентификации системы
        /// </summary>
        [Required]
        public string password { get; set; }
        /// <summary>
        /// Запрос на проверку состояния абонента
        /// </summary>
        [Required]
        public string command { get; set; }
        /// <summary>
        /// Номер транзакции на стороне системы
        /// </summary>
        [Required]
        public long transactionID { get; set; }
        /// <summary>
        /// Внутренний номер платежа в системе
        /// </summary>
        [Required]
        public string cancelPayID { get; set; }
        /// <summary>
        /// Номер сервиса в системе провайдера, используется для случаев если провайдер предоставляет возможность 
        /// пополнения нескольких слуг. Например: интернет и телефон (если сервис один - поле не анализируется)
        /// </summary>
        [Required]
        public int? payElementID { get; set; }
        /// <summary>
        /// Идентификатор абонента в информационной системе провайдера
        /// </summary>
        [Required]
        public string account { get; set; }
        /// <summary>
        /// Сумма к зачислению на лицевой счет абонента
        /// </summary>
        [Required]
        public int amount { get; set; }
    }
}