﻿using System.Net;
using System.Net.Http;
using System.Web.Http;
using PlatezhkaDemoApi.Models;
using PlatezhkaDemoApi.Models.Requests;
using PlatezhkaDemoApi.Models.Responses;

#pragma warning disable 219
#pragma warning disable 162

// ReSharper disable RedundantAssignment
// ReSharper disable HeuristicUnreachableCode

namespace PlatezhkaDemoApi.Controllers
{
    public class CheckController : ApiController
    {
        // POST api/check
        public HttpResponseMessage Post([FromBody]CheckCommand command)
        {
            if (!ModelState.IsValid || command == null)
                return Request.CreateResponse(HttpStatusCode.BadRequest, command);

            int extTransactionId = 0;
            string comment = "";
            ResponseStatusCode result = ResponseStatusCode.Ok;

            if (true) // Проверяем $login, $password, что бы отсекать чужие запросы
            {
                if (true) // Ищем сервис для оплаты (по $payElementID) в Вашей БД
                {
                    if (true) // Проверяем в БД абонента (по $account)
                    {

                        // Здесь нужно сохранить платеж в базу, со статусом не оплачен
                        extTransactionId = 12345; //Записываем сюда номер Вашей транзакции.
                        comment = "Это тестовый платеж"; //Коментарий не обязателен
                    }
                    else
                    {
                        // Идентификатор абонента не найден (Ошиблись номером). 
                        // Здесь может быть другая ошибка, например 79 (Счет абонента не активен)
                        result = ResponseStatusCode.SubscriberIdNotFound;
                        comment = "Идентификатор абонента не найден"; //Коментарий не обязателен
                    }
                }
                else
                {
                    result = ResponseStatusCode.PaymentDeniedByProvider; // Прием платежа запрещен провайдером
                }
            }
            else
            {
                result = ResponseStatusCode.PaymentDeniedByProvider; // Прием платежа запрещен провайдером
            }

            return Request.CreateResponse(HttpStatusCode.OK,
                new CommandResponse(extTransactionId, command.account, result, comment)); ;
        }
    }
}
